/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiPredicate;
import java.util.zip.GZIPInputStream;
import libsidutils.IOUtils;
import libsidutils.ZipFileUtils;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.UploadContents;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.RequestResponseBodyParameter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.NewFileRequestPathServletParameters;
import ui.common.Convenience;
import ui.common.util.Extract7ZipUtil;

@WebServlet(name="UploadServlet", displayName="UploadServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/upload/*"}, description="Upload any C64 content to play it back")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
@MultipartConfig(maxFileSize=0x1100000L, maxRequestSize=0x1100000L, fileSizeThreshold=0)
public class UploadServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.UploadServlet.MAX_UPLOADS_IN_PARALLEL, new DefaultThreadFactory("/upload"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.UploadServlet.UPLOAD_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        UploadServletParameters servletParameters = new UploadServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        UploadContents uploadContents = (UploadContents)UploadServlet.this.getInput(request, UploadContents.class);
                        File file = servletParameters.create(UploadServlet.this.configuration, uploadContents.getContents());
                        ServletUtil.info(UploadServlet.this.getServletContext(), String.format("uploaded: %s (%s)", file, IOUtils.getPhysicalSize(file.length())), new Thread[0]);
                        File result = this.extractUploadFile(file);
                        if (!this.isComplete()) {
                            UploadServlet.this.setOutput(request, response, String.valueOf(result).replace("\\", "/"));
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(UploadServlet.this.getServletContext(), t, new Thread[0]);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        UploadServlet.this.setOutput(response, t);
                    }
                }
            }

            private File extractUploadFile(File file) throws IOException {
                File tmpDir = file.getParentFile();
                TFile tFile = new TFile(file);
                File uploadResult = null;
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) {
                    TFile.cp_rp((File)tFile, (File)tmpDir, (TArchiveDetector)TArchiveDetector.ALL);
                    uploadResult = this.getUploadResult(tmpDir, Convenience.LEXICALLY_FIRST_MEDIA, null);
                } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".gz")) {
                    File dst = new File(tmpDir, IOUtils.getFilenameWithoutSuffix(file.getName()));
                    try (GZIPInputStream is = new GZIPInputStream(ZipFileUtils.newFileInputStream(file));){
                        TFile.cp((InputStream)is, (File)dst);
                    }
                    uploadResult = this.getUploadResult(tmpDir, Convenience.LEXICALLY_FIRST_MEDIA, null);
                } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".7z")) {
                    Extract7ZipUtil extract7Zip = new Extract7ZipUtil((File)tFile, tmpDir);
                    extract7Zip.extract();
                    uploadResult = this.getUploadResult(tmpDir, Convenience.LEXICALLY_FIRST_MEDIA, null);
                } else {
                    uploadResult = file;
                }
                return uploadResult;
            }

            private File getUploadResult(File dir, BiPredicate<File, File> mediaTester, File uploadResult) {
                File[] listFiles = dir.listFiles();
                if (listFiles == null) {
                    return null;
                }
                List<File> asList = Arrays.asList(listFiles);
                asList.sort(Convenience.TOP_LEVEL_FIRST_COMPARATOR);
                for (File member : asList) {
                    File toAttachChild;
                    File memberFile = new File(dir, member.getName());
                    if (memberFile.isFile() && (JSIDPlay2Servlet.CART_FILE_FILTER.accept(memberFile) || JSIDPlay2Servlet.AUDIO_TUNE_FILE_FILTER.accept(memberFile) || JSIDPlay2Servlet.VIDEO_TUNE_FILE_FILTER.accept(memberFile) || JSIDPlay2Servlet.DISK_FILE_FILTER.accept(memberFile) || JSIDPlay2Servlet.TAPE_FILE_FILTER.accept(memberFile))) {
                        if (!mediaTester.test(memberFile, uploadResult)) continue;
                        uploadResult = memberFile;
                        continue;
                    }
                    if (!memberFile.isDirectory() || memberFile.getName().equals("__MACOSX") || (toAttachChild = this.getUploadResult(memberFile, mediaTester, uploadResult)) == null) continue;
                    uploadResult = toAttachChild;
                }
                return uploadResult;
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.UploadServletParameters")
    public static class UploadServletParameters
    extends NewFileRequestPathServletParameters
    implements RequestResponseBodyParameter<UploadContents, String> {
        @Override
        public UploadContents getRequestBodyExample() {
            return new UploadContents(new byte[]{80, 83, 73, 68, 0, 2, 0, 124, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 111, 110, 103, 32, 78, 97, 109});
        }

        @Override
        public String getResponseBodyExample() {
            return "/path/to/file";
        }
    }
}

